//---------------------------------------------------------------------------
// this is the basic syntax-highlighting program from which we
// will try to make significant improvements.  this is *not*
// intended to be a demonstration of the best techniques for
// implementing a syntax-highlighting text editor.  the "parsing"
// technique used here is definitely brain-dead and intended
// only to give us something to work with.
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
// add these
#include <time.h>
#include <ctype.h>
#include <string.h>

// the following defines are used to selectively enable optimizations;
// set to true to enable or false to disable
#define OPT_SETREDRAW			(true)
#define OPT_WINAPI_CHARFORMAT	(true)
#define OPT_NULL_EVENT_HANDLERS (false)
#define OPT_SETEVENTMASK		(true)

//---------------------------------------------------------------------------
#if (__BORLANDC__ >= 0x530)
#pragma package(smart_init)
#endif
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
void __fastcall ParseAllText(TRichEdit* RichEdit1);
TColor GetTokenColor(char* token);
void SetTokenColor(TRichEdit* RichEdit1, TEXTRANGE& tr, TColor color);
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormShow(TObject *Sender)
{
	RichEdit1->Lines->LoadFromFile("Unit1.cpp");
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Exit1Click(TObject *Sender)
{
	Close();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Open1Click(TObject *Sender)
{
	if (OpenDialog1->Execute()) {
		RichEdit1->Lines->LoadFromFile(OpenDialog1->FileName);
		}
}
//---------------------------------------------------------------------------
void __fastcall TForm1::New1Click(TObject *Sender)
{
	RichEdit1->Clear();
}
//---------------------------------------------------------------------------
// any self-respecting editor will include a status bar indicator that
// tracks the current insert/overwrite state.  this demonstration code
// will get it right most (maybe all?) of the time.  note that Rich Edit
// controls are in insert state immediately after creation.  note also
// that you cannot intercept virtual key codes in the KeyPress handler,
// so we use the KeyDown handler.
//
void __fastcall TForm1::RichEdit1KeyDown(TObject *Sender, WORD &Key,
	  TShiftState Shift)
{
	static TShiftState ss;  // intitialized to shift-state of "none"
	static AnsiString Ins("INS");
	static AnsiString Ovr("OVR");

	if (Shift == ss && Key == VK_INSERT)
		StatusBar1->Panels->Items[1]->Text =
			(StatusBar1->Panels->Items[1]->Text == Ins) ? Ovr : Ins;
}
//---------------------------------------------------------------------------
// the following is a simple function that updates the status panel at the
// bottom of the window to reflect the current cursor line position.  this
// is included gratuitously, but I suspect that anyone trying to construct
// a "full-featured syntax-highlighting editor" would include similar code.
//
void __fastcall TForm1::RichEdit1SelectionChange(TObject *Sender)
{
	StatusBar1->Panels->Items[0]->Text = AnsiString("Line ") +
		AnsiString((int)::SendMessage(RichEdit1->Handle, EM_LINEFROMCHAR,
		RichEdit1->SelStart, 0));
}
//---------------------------------------------------------------------------
// the following is a mind-dumbingly simple parser intended for
// demonstration purposes only.
//
void __fastcall TForm1::Parse1Click(TObject *Sender)
{
	// local variables
	clock_t startTime, endTime, netTime;
	int lines;

	// loop repeatedly until statistics messagebox exits...
	bool endStats = false;
	while (!endStats) {

		// initialize
		lines = startTime = endTime = netTime = 0;

#if OPT_SETEVENTMASK
	int eventMask = ::SendMessage(RichEdit1->Handle, EM_SETEVENTMASK, 0, 0);
#endif

#if OPT_NULL_EVENT_HANDLERS
	RichEdit1->OnChange = 0;
	RichEdit1->OnSelectionChange = 0;
	RichEdit1->OnKeyDown = 0;
#endif

#if OPT_SETREDRAW
	::SendMessage(RichEdit1->Handle, WM_SETREDRAW, false, 0);
#endif
		// set the timer
		startTime = clock();

		// parse the entire text
		ParseAllText(RichEdit1);

		// get end time
		endTime = clock();

		// reposition to top
		RichEdit1->SelStart = 0;
		RichEdit1->SelLength = 0;

#if OPT_SETREDRAW
	::SendMessage(RichEdit1->Handle, WM_SETREDRAW, true, 0);
	::InvalidateRect(RichEdit1->Handle, 0, true);
#endif

#if OPT_NULL_EVENT_HANDLERS
	RichEdit1->OnChange = RichEdit1Change;
	RichEdit1->OnSelectionChange = RichEdit1SelectionChange;
	RichEdit1->OnKeyDown = RichEdit1KeyDown;
#endif

#if OPT_SETEVENTMASK
	::SendMessage(RichEdit1->Handle, EM_SETEVENTMASK, 0, eventMask);
#endif

		// get the line count
		lines = RichEdit1->Lines->Count;

		// calculate time
		netTime = endTime - startTime;

		// set up stats for message box
		AnsiString msg = AnsiString("Lines = ") + AnsiString(lines) +
			AnsiString("; Ticks = ") + AnsiString((int)netTime);

		// offer to loop back and try again for multiple timings
		if (Application->MessageBox(msg.c_str(), "Statistics -- Again???", MB_YESNO) !=
			ID_YES) endStats = true;
	}
}
//---------------------------------------------------------------------------
// when writing a syntax-highlighting editor, you would likely implement
// the following event handler or one of the OnKeyxxx handlers to highlight
// or unhighlight words.
//
// for demonstration purposes, we will simply call the GetTokenColor() and
// SetTokenColor() functions for the two "tokens" that break before
// and the two tokens after the current position.
//
void __fastcall TForm1::RichEdit1Change(TObject *Sender)
{
	char tokBuf[256];
	TEXTRANGE tr;
	tr.lpstrText = tokBuf;

	// get the current position
	tr.chrg.cpMax = RichEdit1->SelStart;

	// move back by two word breaks
	tr.chrg.cpMax = ::SendMessage(RichEdit1->Handle, EM_FINDWORDBREAK,
		WB_MOVEWORDLEFT, tr.chrg.cpMax);
	tr.chrg.cpMax = ::SendMessage(RichEdit1->Handle, EM_FINDWORDBREAK,
		WB_MOVEWORDLEFT, tr.chrg.cpMax);

	// process the next four "tokens"
	for (int i = 0; i < 4; i++) {
		tr.chrg.cpMin = tr.chrg.cpMax;
		tr.chrg.cpMax = ::SendMessage(RichEdit1->Handle, EM_FINDWORDBREAK,
			WB_MOVEWORDRIGHT, tr.chrg.cpMin);
		int tempPos = ::SendMessage(RichEdit1->Handle, EM_FINDWORDBREAK,
			WB_RIGHTBREAK, tr.chrg.cpMin);
		if (tempPos < tr.chrg.cpMax) tr.chrg.cpMax = tempPos;
		::SendMessage(RichEdit1->Handle, EM_GETTEXTRANGE, 0, (LPARAM) &tr);
		SetTokenColor(RichEdit1, tr, GetTokenColor(tr.lpstrText));
		}
}
//---------------------------------------------------------------------------
void __fastcall ParseAllText(TRichEdit* RichEdit1)
{
	// scan through text using EM_FINDWORDBREAK to parse into tokens
	// (not exactly a true parser, but good enough for demonstration purposes)
	TColor color;
	int eot = RichEdit1->GetTextLen();
	char tokBuf[256];
	TEXTRANGE tr;
	tr.chrg.cpMin = tr.chrg.cpMax = 0;
	tr.lpstrText = tokBuf;

	while (tr.chrg.cpMax < eot) {
		int tempPos;
		tr.chrg.cpMin = tr.chrg.cpMax;
		tr.chrg.cpMax = ::SendMessage(RichEdit1->Handle, EM_FINDWORDBREAK,
			WB_MOVEWORDRIGHT, tr.chrg.cpMin);
		tempPos = ::SendMessage(RichEdit1->Handle, EM_FINDWORDBREAK,
			WB_RIGHTBREAK, tr.chrg.cpMin);
		if (tempPos < tr.chrg.cpMax) tr.chrg.cpMax = tempPos;
		::SendMessage(RichEdit1->Handle, EM_GETTEXTRANGE, 0, (LPARAM) &tr);
		color = GetTokenColor(tokBuf);
		SetTokenColor(RichEdit1, tr, color);
		}
}
//---------------------------------------------------------------------------
typedef enum tagTokenType {
	ttFlowControl, ttTypeSpec, ttDelimiter
	} TTokenType;

TColor TokenColor[] = { clBlue, clGreen, clRed };

typedef struct {
	char* token;
	TTokenType type;
	} TTokenItem;

TTokenItem TokenList[] = {
	{ "if", ttFlowControl },
	{ "else", ttFlowControl },
	{ "while", ttFlowControl },
	{ "for", ttFlowControl },
	{ "return", ttFlowControl },
	{ "bool", ttTypeSpec },
	{ "char", ttTypeSpec },
	{ "{", ttDelimiter },
	{ "}", ttDelimiter },
	{ "(", ttDelimiter },
	{ ")", ttDelimiter },
	{ ";", ttDelimiter },
	};
//---------------------------------------------------------------------------
TColor GetTokenColor(char* token)
{
	// quick out for simple spaces
	if (iswspace(*token)) return clBlack;

	// scan through token list and return if found
	for (int i = 0; i < (sizeof(TokenList) / sizeof(TokenList[0])); i++)
		if (!strcmp(token, TokenList[i].token))
			return TokenColor[TokenList[i].type];

	return clBlack;
}
//---------------------------------------------------------------------------
void SetTokenColor(TRichEdit* RichEdit1, TEXTRANGE& tr, TColor color)
{
#if !(OPT_WINAPI_CHARFORMAT)
	int selStart = RichEdit1->SelStart;
	int selLength = RichEdit1->SelLength;

	RichEdit1->SelStart = tr.chrg.cpMin;
	RichEdit1->SelLength = tr.chrg.cpMax - tr.chrg.cpMin;
	RichEdit1->SelAttributes->Color = color;

	RichEdit1->SelStart = selStart;
	RichEdit1->SelLength = selLength;
#else
	CHARRANGE chrgSave;
	::SendMessage(RichEdit1->Handle, EM_EXGETSEL, 0, (LPARAM) &chrgSave);
	::SendMessage(RichEdit1->Handle, EM_EXSETSEL, 0, (LPARAM) &tr.chrg);
	CHARFORMAT cf;
	memset(&cf, 0, sizeof(cf));
	cf.cbSize = sizeof(cf);
	cf.dwMask = CFM_COLOR;
	cf.crTextColor = color;
	::SendMessage(RichEdit1->Handle, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM) &cf);
	::SendMessage(RichEdit1->Handle, EM_EXSETSEL, 0, (LPARAM) &chrgSave);
#endif
}
//---------------------------------------------------------------------------

